#include "vmf.h"
#include "tokenreader.h"
#include <windows.h>
#include <string.h>


// ctor
VMF::VMF(void)
{
}

VMF::VMF( char* data )
{
	// simply parse the sucker.
	Parse( data );

}

// dtor
VMF::~VMF(void)
{
	// cleanup entities and their keys.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		// cleanup myself
		delete entities[i];

	}

}


// find entity by class.
entity* VMF::FindEntityByClass( const char* classname )
{
	// find entity by classname.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		if( strcmp( entities[i]->classname, classname ) == 0 )
		{
			return entities[i];

		}

	}

	//
	return NULL;

}

// find entity by class.
entity* VMF::FindEntityByName( const char* name )
{
	// find entity by name.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		if( strcmp( entities[i]->name, name ) == 0 )
		{
			return entities[i];

		}

	}

	//
	return NULL;

}

// find entity by id.
entity* VMF::FindEntityByID( int id )
{
	// find entity by name.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		if( entities[i]->id == id )
		{
			return entities[i];

		}

	}

	//
	return NULL;

}



// rename entities.
void VMF::Rename( int count )
{
	// string it
	char scount[5];
	itoa( count, scount, 4 );

	// extract the names.
	int name_count = 0;
	char names[2048][64];		// HACK: I don't want to fix this value...

	// read names.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		if( !entities[i]->has_name )
		{
			continue;

		}

		// name already in the list?
		bool found = false;
		for( int j = 0; j < name_count; j++ )
		{
			if( strcmp( names[j], entities[i]->name ) == 0 )
			{
				found = true;
				break;

			}

		}

		// not in the list?
		if( !found )
		{
			// add
			//names[ name_count++ ] = entities[i]->name;
			strcpy( names[ name_count++ ], entities[i]->name );

		}

		// update entities name.
		sprintf( entities[i]->name, "%s%d", entities[i]->name, count );

	}

	// write names.
	for( int i = 0; i < name_count; i++ )
	{
		// fetch name.
		char* name = names[i];

		// fix the entities.
		for( int j = 0; j < (int)entities.size(); j++ )
		{
			// fetch entity.
			entity* ent = entities[j];

			// fix keyvalues.
			for( int k = 0; k < (int)ent->keyvalues.size(); k++ )
			{
				// replace?
				if( strcmp( ent->keyvalues[k].value, name ) == 0 )
				{
					sprintf( ent->keyvalues[k].value, "%s%d", ent->keyvalues[k].value, count );
				}

			}

			// fix connections.
			for( int k = 0; k < (int)ent->connections.size(); k++ )
			{
				// replace?
				if( strcmp( ent->connections[k].targetname, name ) == 0 )
				{
					sprintf( ent->connections[k].targetname, "%s%d", ent->connections[k].targetname, count );

				}

			}

		}

	}

}



// parse vmf.
void VMF::Parse( char* data )
{
	// setup a tokenreader
	TokenReader* reader = new TokenReader( data );

	// oih shit
	int depth = 0;
	int current_chunk = CHUNK_NONE;

	// chunk history.
	int history = 0;
	int chunk_history[5] = { CHUNK_NONE, CHUNK_NONE, CHUNK_NONE, CHUNK_NONE, CHUNK_NONE };

	// entity.
	entity* current_entity = NULL;



	// cleanup entitie.
	for( int i = 0; i < (int)entities.size(); i++ )
	{
		// cleanup myself
		delete entities[i];

	}
	entities.clear();
	worldkeys.clear();


	
	// read the vmf data.
	while( true )
	{
		// read a token.
		char buffer[1024];
		Token t = reader->ReadToken( buffer, 1023 );

		//
		if( t == TOKEN_EOF || t == TOKEN_ERROR )
		{
			break;

		}

		// identifier or string?
		else if( t == TOKEN_IDENTIFIER || t == TOKEN_STRING )
		{
			// read another token.
			char next_buffer[1024];
			Token next_t = reader->ReadToken( next_buffer, 1023 );

			// problem?
			if( next_t == TOKEN_EOF || next_t == TOKEN_ERROR )
			{
				break;

			}
			
			// keyvalue pair?
			else if( next_t == TOKEN_IDENTIFIER || next_t == TOKEN_STRING )
			{
				// chunk.
				switch( current_chunk )
				{
					case CHUNK_ENTITY:
						// add keyvalue.
						if( current_entity )
						{
							// add
							keyvalue kv;
							strcpy( kv.key, buffer );
							strcpy( kv.value, next_buffer );
							current_entity->keyvalues.push_back( kv );

							// name?
							if( strcmp( buffer, "targetname" ) == 0 )
							{
								strcpy( current_entity->name, next_buffer );
								current_entity->has_name = true;

							}
						
							// classname?
							else if( strcmp( buffer, "classname" ) == 0 )
							{
								strcpy( current_entity->classname, next_buffer );

							}

							// id?
							else if( strcmp( buffer, "id" ) == 0 )
							{
								current_entity->id = atoi( next_buffer );

							}

						}

						break;

					case CHUNK_CONNECTIONS:
						// add connection.
						if( current_entity )
						{
							// add
							connection conn;
							
							// store output
							strcpy( conn.output, buffer );

							// split targetname.
							char* fnd = strchr( next_buffer, ',' );

							// targetname.
							strncpy( conn.targetname, next_buffer, fnd - next_buffer );
							conn.targetname[ fnd - next_buffer ] = '\0';

							// fire
							strcpy( conn.fire, fnd + 1 );

							// add.
							current_entity->connections.push_back( conn );
							
						}

						break;

					case CHUNK_WORLD:
						{
							// world keyvalue.
							keyvalue kv;
							strcpy( kv.key, buffer );
							strcpy( kv.value, next_buffer );

							// add
							worldkeys.push_back( kv );

						}

						break;

					case CHUNK_SOLID:
					case CHUNK_SIDE:
						// side data.

						break;

				}

			}

			// opening a new block?
			else if( next_t == TOKEN_OPERATOR && next_buffer[0] == '{' )
			{
				// go deeper
//				depth++;

				// add to chunk history.
				chunk_history[ history++ ] = current_chunk;

				// select new chunk.
				if( strcmp( buffer, "entity" ) == 0 )
				{
					// create a new entity.
					current_entity = new entity;
					current_entity->has_name = false;

					// store newly created entity in the list.
					entities.push_back( current_entity );

					// chunk
					current_chunk = CHUNK_ENTITY;

				}
				else if( strcmp( buffer, "world" ) == 0 )
				{
					// chunk
					current_chunk = CHUNK_WORLD;

				}
				else if( strcmp( buffer, "connections" ) == 0 )
				{
					// chunk
					current_chunk = CHUNK_CONNECTIONS;

				}
				else if( strcmp( buffer, "solid" ) == 0 )
				{
					// chunk
					current_chunk = CHUNK_SOLID;

				}
				else if( strcmp( buffer, "side" ) == 0 )
				{
					// chunk
					current_chunk = CHUNK_SIDE;

				}
				else
				{
					// chunk
					current_chunk = CHUNK_MISC;

				}

			}

		}

		// closing a block?
		else if( t == TOKEN_OPERATOR && buffer[0] == '}' )
		{
			// become more shallow.
//			depth--;

			// extract from history.
			current_chunk = chunk_history[ --history ];
			

		}

	}

	// cleanup
	delete reader;

}
